; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; PROCEDURE:
; create_magpos_file.pro : IDL procedure
; require tu_julsec_to_isodatea.pro IDL procedure.
;         
; PURPOSE:
;      procedure to create 4 ascii files containg magnetic data and position
;      measured at four points in space, at the same time.
;      can be used for 4 S/C missions, as CLUSTER or MMS.
;      The file are named "addvecpos_N.resu" to be used by the Roproc software.
;      (N=1,2,3,4).
;
; INPUT:  (examples)
;       mission='MMS' ou 'CLUSTER'
;       experi='FGM'
;       satname='Tango' or 'MMS-4'
;       satnum =1 to 4
;       coord='GSE'
;       com=STRARR(5)
;       example for CLUSTER:
;           com(0)='Cluster is a set of 4 Spacecraft, lauchned in summer 2000.'
;           com(1)='The Flux Gate Magnetometer experiment (FGM) measure the 3 components'
;           com(2)='of the DC magnetic field.'
;           com(3)='The time resolution is varying: the low time resolution, also called'
;           com(4)='Prime Parameter Data (PPD) is of the order of the spin period (4 s),'
;           com(5)='while the high resolution is around 0.04 s.' 
;       sattim=FLTARR(n) : time in Julian second since 1970/01/01
;       Valpos: position at each vertice of the tetrahedron (km)
;               DBLE [N_time, 3 (xyz), 4 (S/C) ]
;       Valmag: value of the magnetic field at each vertice of the tetrahedron (nT)
;               DBLE [N_time, 3 (xyz), 4 (S/C) ]
;
; OUTPUT:
;        addvecpos_N.resu ascii files with Roproc header (N=1,2,3,4).
;        block data content as "ISO_date, Bx,By,Bz, Px,Py,Pz).
;
;$CreatedBy: P. Robert $
;$LastChangedDate: 2015-11-25 
;
; -------------------------------------------------------------------------------

  PRO create_magpos_file, mission,experi,satname,satnum, coord,com,sattim,valpos,valmag


  nbvec   = N_ELEMENTS(sattim)
  ncom    = N_ELEMENTS(com)
  csatnum = STRING(satnum,format='(i1)')
  cnbvec  = STRTRIM(STRING(nbvec),1)
  credate = datim_iso()
  format  = '(a27,6e15.6)'

  GET_LUN, Unit

  filename=STRING(satnum,format="('addvecpos_',i1,'.resu')")
  
  OPENW, Unit, filename
  
  PRINTF, Unit, format='(5a)', '# ----------------------------------------------------------------------'
  PRINTF, Unit, format='(5a)', '# File type Roproc_Vector_Format'
  PRINTF, Unit, format='(5a)', '# can be used by Roproc_Vector Library'
  PRINTF, Unit, format='(5a)', '# Version 1.0, P. Robert, CETP, Septembre 2002'
  PRINTF, Unit, format='(5a)', '# ----------------------------------------------------------------------'
  PRINTF, Unit, format='(5a)', '# BEGIN CONSTANT'
  PRINTF, Unit, format='(5a)', '# INT : DATA_SET_NUMBER   : 16'
  PRINTF, Unit, format='(5a)', '# CHA : MISSION_NAME      : ', mission
  PRINTF, Unit, format='(5a)', '# CHA : INSTRUMENT_NAME   : ', experi
  PRINTF, Unit, format='(5a)', '# CHA : SPACECRAFT_NAME   : ', satname
  PRINTF, Unit, format='(5a)', '# INT : SPACECRAFT_NUMBER : ', csatnum
  PRINTF, Unit, format='(6a)', '# CHA : MAIN_TITLE        : ', mission,' / ',experi,' / ',satname
  PRINTF, Unit, format='(5a)', '# CHA : TARGET_NAME       : Magnetospheric Study'
  PRINTF, Unit, format='(5a)', '# CHA : DATA_TYPE         : DateTime_Subscript_Vector'
  PRINTF, Unit, format='(5a)', '# CHA : NATURE            : B DC magnetic field, time aligned'
  PRINTF, Unit, format='(5a)', '# CHA : UNIT              : nT'
  PRINTF, Unit, format='(5a)', '# CHA : COORDINATE_SYSTEM : ', coord
  PRINTF, Unit, format='(5a)', '# INT : NB_COMPONENTS     : 6'
  PRINTF, Unit, format='(5a)', '# INT : NB_VECTORS        : ', cnbvec
  PRINTF, Unit, format='(5a)', '# CHA : FORMAT            : ', format
  PRINTF, Unit, format='(5a)', '# CHA : CREATION_DATE     : ', credate
  PRINTF, Unit, format='(5a)', '# END CONSTANT'
  PRINTF, Unit, format='(5a)', '# ----------------------------------------------------------------------'
  PRINTF, Unit, format='(5a)', '# BEGIN COMMENTS'
  FOR i=0,ncom-1 DO $
  PRINTF, Unit, format='(5a)', '# ',com(i)
  PRINTF, Unit, format='(5a)', '# END COMMENTS'
  PRINTF, Unit, format='(5a)', '# ----------------------------------------------------------------------'
  PRINTF, Unit, format='(5a)', '# BEGIN DATA_DESCRIPTION'
  PRINTF, Unit, format='(5a)', '# This vector data file contains DateTime_Subscript_Vector data type,'
  PRINTF, Unit, format='(5a)', '# and therefore is structured as a temporal serie of data blocs.'
  PRINTF, Unit, format='(5a)', '# Each bloc begin with the date-time epoch in ISO format.'
  PRINTF, Unit, format='(5a)', '# The rest of the bloc data is a serie of NB_COMPONENTS values,'
  PRINTF, Unit, format='(5a)', '# corresponding to the number of component of the time data vector.'
  PRINTF, Unit, format='(5a)', '# END DATA_DESCRIPTION'
  PRINTF, Unit, format='(5a)', '# ----------------------------------------------------------------------'
  PRINTF, Unit, format='(5a)', '# BEGIN DATA'
  
  ; convert time in ISO date-time
  
  isodate = tu_julsec_to_isodatea(sattim, 6)

  FOR i=0,nbvec-1 DO $
  PRINTF, Unit, FORMAT=format,isodate(i),valmag(i,0),valmag(i,1),valmag(i,2),valpos(i,0),valpos(i,1),valpos(i,2)
  PRINTF, Unit, format='(5a)', '# END DATA'
  
  CLOSE, Unit
  
  RETURN
  END
  
; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX  
