; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; IDL MAIN CRIB SHEET:
; crib_MAIN_mms_curlometer_crefiles.pro : Main IDL file
;         
; PURPOSE:
;         load DFG or/and AFG data with positions for the 4 s/c
;	      Interpolate all mag and position data to 1 reference s/c
;	      create 4 files addvecpos_1,2,3,4.resu containing
;         date_iso, bX,bY,bZ, pX,pY,pZ
;
; USAGE: @crib_MAIN_mms_curlometer_crefiles.pro
;
; require crib sheet  crib_compile_mms_curlometer_crefiles.pro
;                     crib_mag_and_pos_time_alignment.pro
;                     crib_check_data_alignment.pro
;                     crib_check_data_size.pro
;                     crib_make_arrays_for_curlometer.pro
;
;$CreatedBy: O. Le Contel & P. Robert  2015-11-28 $
;$LastChangedDate:  2015-12-07
;
; -------------------------------------------------------------------------------

;    ============================================ 
; 0) Library paths and compile all used procedure (allow a clean output)
;    ============================================

  !path=!path+':'+expand_path('+general',/ALL_DIRS)
  !path=!path+':'+expand_path('+spdsw_r19402_2015-11-17',/ALL_DIRS)
  
  PRINT, '------------------------------------------------------------'
  PRINT, 'compile_mms_crib_curlometer.pro'
  
  @crib_compile_mms_curlometer_crefiles.pro

;    ================
; 1) clean tplot data 
;    ================

  PRINT, '------------------------------------------------------------'
  PRINT, 'clean tplot data'
  
  del_data,'*'

;    =========================
; 2) Set date and  time period
;    =========================

; 20151030 (10 km) MP crossing

  date = '2015-10-30/00:00:00' 

  timespan,date,1,/day
  
  starting_date =strmid(date,0,10)
  starting_time ='05:15:45.000'
  ending_time   ='05:15:48.000'

  trange = [starting_date+'/'+starting_time, $
            starting_date+'/'+ending_time]

 
;    =================================
; 3) load MMS l1b DFG data for MMS 1-4
;    =================================           

  PRINT, '------------------------------------------------------------'
  PRINT, 'set FGM modes'
  
;=== Select DC mag ('DFG' or 'AFG')
  mag = 'dfg'
  
;=== Select FGM data_rates
  dfg_data_rate = 'brst'
  afg_data_rate = 'brst';'srvy'

  if mag eq 'dfg' then mag_data_rate = dfg_data_rate 
  if mag eq 'afg' then mag_data_rate = afg_data_rate 

;=== Select FGM level ('ql' for quicklook, 'l1a', 'l1b', 'l2pre','l2')
  dfg_level_input = 'l2pre'  ;'ql' ;'l1b'
  afg_level_input = 'l2pre'  ;'ql'
  
  if mag eq 'dfg' then mag_level_input= dfg_level_input
  if mag eq 'afg' then mag_level_input= afg_level_input

;=== Select mag frame for L2 data ('gse' or 'gsm_dmpa')
  coord_dfg_input = 'gse';'gsm_dmpa'
  coord_afg_input = 'gse';'gsm_dmpa'

  if mag eq 'dfg' then coord_mag_input = coord_dfg_input 
  if mag eq 'afg' then coord_mag_input = coord_afg_input
  
  PRINT, 'done...'
  
;    ----------------------
;=== MAG DATA AND POSITIONS
;    ----------------------

; loading ; local_data_dir = local_data_dir

  PRINT, '------------------------------------------------------------'
  PRINT,'load MMS l1b DFG data for MMS 1-4'
  PRINT
  
  mms_load_fgm, probes='1', trange=trange, instrument=mag,data_rate= mag_data_rate,level= mag_level_input,/no_update
  if mag eq 'dfg' then mag_data_rate = dfg_data_rate 
  if mag eq 'afg' then mag_data_rate = afg_data_rate 

  mms_load_fgm, probes='2', trange=trange, instrument=mag, data_rate= mag_data_rate,level= mag_level_input,/no_update
  if mag eq 'dfg' then mag_data_rate = dfg_data_rate 
  if mag eq 'afg' then mag_data_rate = afg_data_rate 

  mms_load_fgm, probes='3', trange=trange, instrument=mag, data_rate= mag_data_rate,level= mag_level_input,/no_update
  if mag eq 'dfg' then mag_data_rate = dfg_data_rate 
  if mag eq 'afg' then mag_data_rate = afg_data_rate 

  mms_load_fgm, probes='4', trange=trange, instrument=mag, data_rate= mag_data_rate,level= mag_level_input,/no_update
  if mag eq 'dfg' then mag_data_rate = dfg_data_rate 
  if mag eq 'afg' then mag_data_rate = afg_data_rate 

; coord

  PRINT, '------------------------------------------------------------'
  PRINT, 'define ccord'
  
  if mag_level_input eq 'l1a'   then coord_mag = mag+'123'
  if mag_level_input eq 'l1b'   then coord_mag = 'omb' else coord_mag = coord_mag_input
  if mag_level_input eq 'l2pre' then coord_mag = coord_mag_input

  PRINT, 'Done...'
      
; rate  

  PRINT, '------------------------------------------------------------'
  PRINT, 'define rate'
  
  if mag_data_rate eq 'brst' then mms1_mag_name  = 'mms1_'+mag+'_'+mag_data_rate+'_'+mag_level_input+'_'+coord_mag  $
                             else vmms1_mag_name = 'mms1_'+mag+'_'+mag_data_rate+'_'+coord_mag

  if mag_data_rate eq 'brst' then mms2_mag_name = 'mms2_'+mag+'_'+mag_data_rate+'_'+mag_level_input+'_'+coord_mag  $
                             else mms2_mag_name = 'mms2_'+mag+'_'+mag_data_rate+'_'+coord_mag

  if mag_data_rate eq 'brst' then mms3_mag_name = 'mms3_'+mag+'_'+mag_data_rate+'_'+mag_level_input+'_'+coord_mag  $
                             else mms3_mag_name = 'mms3_'+mag+'_'+mag_data_rate+'_'+coord_mag

  if mag_data_rate eq 'brst' then mms4_mag_name = 'mms4_'+mag+'_'+mag_data_rate+'_'+mag_level_input+'_'+coord_mag  $
                             else mms4_mag_name = 'mms4_'+mag+'_'+mag_data_rate+'_'+coord_mag
  PRINT, 'Done...'
  
;    ----------------------
;=== S/C POSITIONS
;    ----------------------

; download four s/c positions ('def' for definitive, 'pred' for predictive if definitive not available)
; mms_load_state, level='def', datatypes='pos'
; Not needed as s/c positions are already stored in mag cdf files, both in gse and gsm.

  PRINT, '------------------------------------------------------------'
  PRINT, 'load positions'
  
  mms1_pos_name = 'mms1_pos_'+coord_mag_input
  mms2_pos_name = 'mms2_pos_'+coord_mag_input
  mms3_pos_name = 'mms3_pos_'+coord_mag_input
  mms4_pos_name = 'mms4_pos_'+coord_mag_input
  
  PRINT, 'Done...'


;    ============================
; 4) Time alignment/interpolation
;    ============================         

  reference_sat = mms1_mag_name

; time alignment of magnetic and position data from "reference_sat" mag data
; and creating data arrays

  PRINT, '------------------------------------------------------------'
  PRINT, '@mag_and_pos_time_alignment.pro'
  
  @crib_mag_and_pos_time_alignment.pro
  

;    ===========================================
; 5) CREATE 4 FILES FOR CURLOMETER CALCULATIONS
;    ===========================================         
    
  PRINT, '------------------------------------------------------------'
  PRINT, '@crib_check_data_size'
  
  @crib_check_data_size
 
  PRINT, '------------------------------------------------------------'
  PRINT, '@crib_check_data_alignment'
  
  @crib_check_data_alignment
  
  PRINT, '------------------------------------------------------------'
  PRINT, '@crib_make_arrays_for_curlometer'
  
  @crib_make_arrays_for_curlometer.pro

  PRINT, '------------------------------------------------------------'
  PRINT, 'input arrays for curlometer computation: [time,xyz,S/C]'

  help, sattim
  help, valpos,valmag

  PRINT, '------------------------------------------------------------'
  PRINT, 'reduce input arrays to starting and ending time''  
  
  ind=WHERE(sattim GE trange(0) AND sattim LE trange(1))
  sattim=sattim(ind)
  valmag=valmag(ind,*,*)
  
  help, sattim, valpos, valmag  

  PRINT, '------------------------------------------------------------'
  PRINT, 'create 4 addvecpos_?.resu file'  
 
  create_magpos_file, 'MMS','FGM','MMS-1',1,'GSE',com,sattim,valpos(*,*,0),valmag(*,*,0)
  create_magpos_file, 'MMS','FGM','MMS-1',2,'GSE',com,sattim,valpos(*,*,1),valmag(*,*,1)
  create_magpos_file, 'MMS','FGM','MMS-1',3,'GSE',com,sattim,valpos(*,*,2),valmag(*,*,2)
  create_magpos_file, 'MMS','FGM','MMS-1',4,'GSE',com,sattim,valpos(*,*,3),valmag(*,*,3)
  
  PRINT, '------------------------------------------------------------'
  PRINT, 'crib_MAIN_mms_curlometer_crefiles done!
  PRINT, '------------------------------------------------------------'
  
; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX  
             
 


