; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; IDL MAIN CRIB SHEET:
; crib_check_data_alignment.pro : Main IDL file
;         
; PURPOSE:
;        load DFG or/and AFG data with positions for the 4 s/c
;        Interpolate all mag and position data to 1 reference s/c
;        Compute the curl of B
;        Plot four Bx,By,Bz,Btot + Dij,J_cur,Div,Div_Curl,
;             JXB,JXB_Norm,JB_Angle
;
; USAGE: @crib_MAIN_mms_curlometer_tplot.pro
;
; require crib sheet  crib_compile_mms_curlometer_tplot.pro
;                     crib_mag_and_pos_time_alignment.pro
;                     crib_check_data_alignment.pro
;                     crib_check_data_size.pro
;                     crib_make_arrays_for_curlometer.pro
;                     crib_tplot_option_for_curlometer.pro
;
;$CreatedBy: O. Le Contel & P. Robert  2015-11-28 $
;$LastChangedDate:  2015-12-07
;
; -------------------------------------------------------------------------------

;    ============================================ 
; 0) Library paths and compile all used procedure (allow a clean output)
;    ============================================

  !path=!path+':'+expand_path('+general',/ALL_DIRS)
  !path=!path+':'+expand_path('+spdsw_r19402_2015-11-17',/ALL_DIRS)
  
  PRINT, '------------------------------------------------------------'
  PRINT, 'crib_compile_mms_curlometer_tplot.pro'
  
  @crib_compile_mms_curlometer_tplot.pro

;    ================
; 1) clean tplot data 
;    ================

  PRINT, '------------------------------------------------------------'
  PRINT, 'clean tplot data'
  
  del_data,'*'

;    =========================
; 2) Set date and  time period
;    =========================

; 20151030 (10 km) MP crossing

  date = '2015-10-30/00:00:00' 

  timespan,date,1,/day
  
  starting_date =strmid(date,0,10)
  starting_time ='05:15:45.000'
  ending_time   ='05:15:48.000'

  trange = [starting_date+'/'+starting_time, $
            starting_date+'/'+ending_time]

 
;    =================================
; 3) load MMS l1b DFG data for MMS 1-4
;    =================================           

  PRINT, '------------------------------------------------------------'
  PRINT, 'set FGM modes'
  
;=== Select DC mag ('DFG' or 'AFG')
  mag = 'dfg'
  
;=== Select FGM data_rates
  dfg_data_rate = 'brst'
  afg_data_rate = 'brst';'srvy'

  if mag eq 'dfg' then mag_data_rate = dfg_data_rate 
  if mag eq 'afg' then mag_data_rate = afg_data_rate 

;=== Select FGM level ('ql' for quicklook, 'l1a', 'l1b', 'l2pre','l2')
  dfg_level_input = 'l2pre'  ;'ql' ;'l1b'
  afg_level_input = 'l2pre'  ;'ql'
  
  if mag eq 'dfg' then mag_level_input= dfg_level_input
  if mag eq 'afg' then mag_level_input= afg_level_input

;=== Select mag frame for L2 data ('gse' or 'gsm_dmpa')
  coord_dfg_input = 'gse';'gsm_dmpa'
  coord_afg_input = 'gse';'gsm_dmpa'

  if mag eq 'dfg' then coord_mag_input = coord_dfg_input 
  if mag eq 'afg' then coord_mag_input = coord_afg_input
  
  PRINT, 'done...'
  
;    ----------------------
;=== MAG DATA AND POSITIONS
;    ----------------------

; loading ; local_data_dir = local_data_dir

  PRINT, '------------------------------------------------------------'
  PRINT,'load MMS l1b DFG data for MMS 1-4'
  PRINT
  
  mms_load_fgm, probes='1', trange=trange, instrument=mag, $
            data_rate= mag_data_rate,level= mag_level_input,/no_update
  if mag eq 'dfg' then mag_data_rate = dfg_data_rate 
  if mag eq 'afg' then mag_data_rate = afg_data_rate 

  mms_load_fgm, probes='2', trange=trange, instrument=mag, $
            data_rate= mag_data_rate,level= mag_level_input,/no_update
  if mag eq 'dfg' then mag_data_rate = dfg_data_rate 
  if mag eq 'afg' then mag_data_rate = afg_data_rate 

  mms_load_fgm, probes='3', trange=trange, instrument=mag, $
            data_rate= mag_data_rate,level= mag_level_input,/no_update
  if mag eq 'dfg' then mag_data_rate = dfg_data_rate 
  if mag eq 'afg' then mag_data_rate = afg_data_rate 

  mms_load_fgm, probes='4', trange=trange, instrument=mag, $
            data_rate= mag_data_rate,level= mag_level_input,/no_update
  if mag eq 'dfg' then mag_data_rate = dfg_data_rate 
  if mag eq 'afg' then mag_data_rate = afg_data_rate 

; coord

  PRINT, '------------------------------------------------------------'
  PRINT, 'define ccord'
  
  if mag_level_input eq 'l1a'   then coord_mag = mag+'123'
  if mag_level_input eq 'l1b'   then coord_mag = 'omb' $
                                else coord_mag = coord_mag_input
  if mag_level_input eq 'l2pre' then coord_mag = coord_mag_input

  PRINT, 'Done...'
      
; rate  

  PRINT, '------------------------------------------------------------'
  PRINT, 'define rate'
  
  if mag_data_rate eq 'brst' then mms1_mag_name = 'mms1_'+mag+'_'+mag_data_rate+'_'+mag_level_input+'_'+coord_mag  $
                             else mms1_mag_name = 'mms1_'+mag+'_'+mag_data_rate+'_'+coord_mag

  if mag_data_rate eq 'brst' then mms2_mag_name = 'mms2_'+mag+'_'+mag_data_rate+'_'+mag_level_input+'_'+coord_mag  $
                             else mms2_mag_name = 'mms2_'+mag+'_'+mag_data_rate+'_'+coord_mag

  if mag_data_rate eq 'brst' then mms3_mag_name = 'mms3_'+mag+'_'+mag_data_rate+'_'+mag_level_input+'_'+coord_mag  $
                             else mms3_mag_name = 'mms3_'+mag+'_'+mag_data_rate+'_'+coord_mag

  if mag_data_rate eq 'brst' then mms4_mag_name = 'mms4_'+mag+'_'+mag_data_rate+'_'+mag_level_input+'_'+coord_mag  $
                             else mms4_mag_name = 'mms4_'+mag+'_'+mag_data_rate+'_'+coord_mag
  PRINT, 'Done...'
  
;    ----------------------
;=== S/C POSITIONS
;    ----------------------

; download four s/c positions ('def' for definitive, 
;                    'pred' for predictive if definitive not available)
; mms_load_state, level='def', datatypes='pos'
; Not needed as s/c positions are already stored in mag cdf files, 
; both in gse and gsm.

  PRINT, '------------------------------------------------------------'
  PRINT, 'load positions'
  
  mms1_pos_name = 'mms1_pos_'+coord_mag_input
  mms2_pos_name = 'mms2_pos_'+coord_mag_input
  mms3_pos_name = 'mms3_pos_'+coord_mag_input
  mms4_pos_name = 'mms4_pos_'+coord_mag_input
  
  PRINT, 'Done...'


;    ============================
; 4) Time alignment/interpolation
;    ============================         

  reference_sat = mms1_mag_name

; time alignment of magnetic and position data from "reference_sat" 
; mag data and creating data arrays

  PRINT, '------------------------------------------------------------'
  PRINT, '@mag_and_pos_time_alignment.pro'
  
  @crib_mag_and_pos_time_alignment.pro
  
  
;    ============================
; 5) CURLOMETER CALCULATIONS
;    ============================         
    
  PRINT, '------------------------------------------------------------'
  PRINT, '@crib_check_data_size'
  
  @crib_check_data_size
 
  PRINT, '------------------------------------------------------------'
  PRINT, '@crib_check_data_alignment'
  
  @crib_check_data_alignment
  
  PRINT, '------------------------------------------------------------'
  PRINT, '@crib_make_arrays_for_curlometer'
  
  @crib_make_arrays_for_curlometer.pro

  PRINT, '------------------------------------------------------------'
  PRINT, 'input arrays for curlometer computation: [time,xyz,S/C]'

  help, sattim, valpos, valmag

  PRINT, '------------------------------------------------------------'
  PRINT, 'reduce input arrays to starting and ending time'
  
  ind=WHERE(sattim GE trange(0) AND sattim LE trange(1))
  sattim=sattim(ind)
  valpos=valpos(ind,*,*)
  valmag=valmag(ind,*,*)
  
  help, sattim, valpos, valmag    

  PRINT, '------------------------------------------------------------'
  PRINT, 'curlometer computation and derived parameters:'  
 
  cocurldiv, sattim,valpos,valmag,  mu0,Curl,Div,Bave,Jcd,JXB,JXB_Norm, $
             JB_Angle,Norm_Osc,Curv_Rad
  cointdist, valpos, d12, d13, d14, d23, d24, d34

  DivsCurl = Div(*)/SQRT(Curl(*,0)^2 + Curl(*,1)^2 + Curl(*,2)^2)

  nbp = n_elements(sattim)

  Dij = FLTARR(nbp,6)
  Dij(*,0) = d12
  Dij(*,1) = d13
  Dij(*,2) = d14
  Dij(*,3) = d23
  Dij(*,4) = d24
  Dij(*,5) = d34
  
  store_data, 'J_cd'    , sattim, Jcd
  store_data, 'Div'     , sattim, Div
  store_data, 'Div_Curl', sattim, DivsCurl
  store_data, 'JXB'     , sattim, JXB
  store_data, 'JXB_Norm', sattim, JXB_Norm
  store_data, 'JB_Angle', sattim, JB_Angle
  store_data, 'Dij'     , sattim, Dij       
            
;    ============================
; 6) PLOT RESULTS
;    ============================  

  PRINT, '------------------------------------------------------------'
  PRINT, '@crib_tplot_option_for_curlometer'
  
  @crib_tplot_option_for_curlometer           

  PRINT, '------------------------------------------------------------'
  PRINT, 'Summary plot'
  
; plot the FGM and FPI data 

  tplot, ['all_bx','all_by','all_bz','all_b','Dij','J_cd','Div', $
          'Div_Curl','JXB','JXB_Norm', 'JB_Angle']
         
  tlimit, trange

  PRINT, '------------------------------------------------------------'
  PRINT, 'Create png file'
  
  dir_name_plot = 'results'
    
  date8 = strmid(date,0,4) + strmid(date,5,2) + strmid(date,8,2)
  filename_png = 'mms1234_spedas_'+mag+'_'+mag_data_rate+'_'+mag_level_input+'_pos'+coord_mag+$
                 '_'+date8+'_'+T1+'_'+T2+'.png'
   
  pathname_png = dir_name_plot+'/'+filename_png
  
  PRINT,"path of png file:",pathname_png
  write_png,pathname_png,tvrd(true=1,/order),/order

  PRINT, '------------------------------------------------------------'
  PRINT, 'Create PS file'
  
  psfile=FILE_BASENAME(filename_png, '.png') +'.ps' 
  popen, psfile, /port, dir=dir_name_plot
  loadct2, 39
  tplot_options, 'charsize',0.7
  tplot
  pclose
  
  PRINT, '------------------------------------------------------------'
  PRINT, 'crib_MAIN_mms_curlometer_tplot done!
  PRINT, '------------------------------------------------------------'
  


