; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; IDL CRIB SHEET:
; crib_check_data_alignment.pro : include IDL file
;         
; PURPOSE:
;        check time alignment of data arrays
;        used as include file by crib_MAIN_mms_curlometer_tplot.pro
;
; USAGE: @crib_check_data_alignment.pro
;
;$CreatedBy: P. Robert, ScientiDev, 2015-11-24 $
;$LastChangedDate:  2015-11-24
; -----------------------------------------------------------------------

  PRINT, ' check data time alignment ; NOTE: time is is sec from 1/1/1970'

  diffP2=timpos2-timpos1
  diffP3=timpos3-timpos1
  diffP4=timpos4-timpos1
  
  diffB2=timmag2-timmag1
  diffB3=timmag3-timmag1
  diffB4=timmag4-timmag1 
  
  diffPB= timpos1 - timmag1
  
  test1=TOTAL([diffP2, diffP3, diffP4])
  test2=TOTAL([diffB2, diffB3, diffB4])
  test3=TOTAL(diffPB)
  
  PRINT
  PRINT, 'All tests must be =0:
  PRINT, FORMAT='(a,E24.16)', 'test1 on time positions, test1=',test1
  PRINT, FORMAT='(a,E24.16)', 'test2 on time mag field, test2=',test2
  PRINT, FORMAT='(a,E24.16)', 'test3 on time pos -mag , test3=',test3
  PRINT
  
; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX  
