; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; IDL CRIB SHEET:
; crib_mag_and_pos_time_alignment.pro : include IDL file
;         
; PURPOSE:
;       time alignment of magnetic and position data from reference_sat mag data
;       and creating corresponding data arrays.
;       used as include file by crib_MAIN_mms_curlometer_tplot.pro
;
; USAGE: @crib_mag_and_pos_time_alignment.pro
;
;$CreatedBy:  O. Le Contel & P. Robert, 2015-11-24 $
;$LastChangedDate:  2015-11-24
; -----------------------------------------------------------------------------


  PRINT, 'time alignment of 4 S/C mag data'
  PRINT

  if reference_sat eq mms1_mag_name then begin $
                                       & tinterpol_mxn,mms2_mag_name,reference_sat $
                                       & tinterpol_mxn,mms3_mag_name,reference_sat $
                                       & tinterpol_mxn,mms4_mag_name,reference_sat $
                                         
                                       & get_data, reference_sat,          timmag1,valmag1 $
                                       & get_data, mms2_mag_name+'_interp',timmag2,valmag2 $
                                       & get_data, mms3_mag_name+'_interp',timmag3,valmag3 $
                                       & get_data, mms4_mag_name+'_interp',timmag4,valmag4 $
                                       & endif

  if reference_sat eq mms2_mag_name then begin $
                                       & tinterpol_mxn,mms1_mag_name,reference_sat $
                                       & tinterpol_mxn,mms3_mag_name,reference_sat $
                                       & tinterpol_mxn,mms4_mag_name,reference_sat $
                                         
                                       & get_data, reference_sat,          timmag2,valmag2 $
                                       & get_data, mms1_mag_name+'_interp',timmag1,valmag1 $
                                       & get_data, mms3_mag_name+'_interp',timmag3,valmag3 $
                                       & get_data, mms4_mag_name+'_interp',timmag4,valmag4 $
                                       & endif
  
  if reference_sat eq mms3_mag_name then begin $
                                       & tinterpol_mxn,mms1_mag_name,reference_sat $
                                       & tinterpol_mxn,mms2_mag_name,reference_sat $
                                       & tinterpol_mxn,mms4_mag_name,reference_sat $
                                         
                                       & get_data, reference_sat,          timmag3,valmag3 $
                                       & get_data, mms1_mag_name+'_interp',timmag1,valmag1 $
                                       & get_data, mms2_mag_name+'_interp',timmag2,valmag2 $
                                       & get_data, mms4_mag_name+'_interp',timmag4,valmag4 $
                                       & endif
                                       
  if reference_sat eq mms4_mag_name then begin $
                                       & tinterpol_mxn,mms1_mag_name,reference_sat $
                                       & tinterpol_mxn,mms2_mag_name,reference_sat $
                                       & tinterpol_mxn,mms3_mag_name,reference_sat $
                                         
                                       & get_data, reference_sat,          timmag4,valmag4 $
                                       & get_data, mms1_mag_name+'_interp',timmag1,valmag1 $
                                       & get_data, mms2_mag_name+'_interp',timmag2,valmag2 $
                                       & get_data, mms3_mag_name+'_interp',timmag3,valmag3 $
                                       & endif
                                       
  PRINT
  PRINT, 'time alignment of 4 S/C positions'

  tinterpol_mxn,mms1_pos_name,reference_sat
  tinterpol_mxn,mms2_pos_name,reference_sat
  tinterpol_mxn,mms3_pos_name,reference_sat
  tinterpol_mxn,mms4_pos_name,reference_sat
  
  PRINT
  PRINT, 'create time and positions arrays'

  get_data,'mms1_pos_gse_interp' , timpos1,valpos1
  get_data,'mms2_pos_gse_interp' , timpos2,valpos2
  get_data,'mms3_pos_gse_interp' , timpos3,valpos3
  get_data,'mms4_pos_gse_interp' , timpos4,valpos4

  PRINT
  PRINT, 'Arrays characteristics'
  help, timpos1,timpos2,timpos3,timpos4
  help, timmag1,timmag2,timmag3,timmag4
  PRINT
  help,valmag1,valmag2,valmag3,valmag4
  PRINT
  
; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX  
