; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; IDL CRIB SHEET:
; crib_make_arrays_for_curlometer.pro : include IDL file
;         
; PURPOSE:
;        make arrays valpos and valmag for curlometer computation
;        used as include file by crib_MAIN_mms_curlometer_tplot.pro
;
; USAGE: @crib_make_arrays_for_curlometer.pro
;
;$CreatedBy: P. Robert, ScientiDev, 2015-11-25 $
;$LastChangedDate:  2015-11-25
; ----------------------------------------------------------------------


  PRINT, 'Make arrays for curlometer computation'   
  
; group usefull array and release the other  
; -----------------------------------------

; 1) a single array for time

  sattim=timmag1

  timpos1=0 & timpos2=0 & timpos3=0 &timpos4=0
  timmag1=0 & timmag2=0 & timmag3=0 &timmag4=0

; a single 3D array for position (time,xyz,S/C)

  valpos=dblarr(np1,3,4)
  
  valpos(*,0,0)=valpos1(*,0)
  valpos(*,1,0)=valpos1(*,1)
  valpos(*,2,0)=valpos1(*,2)
  

  valpos(*,0,1)=valpos2(*,0)
  valpos(*,1,1)=valpos2(*,1)
  valpos(*,2,1)=valpos2(*,2)

  valpos(*,0,2)=valpos3(*,0)
  valpos(*,1,2)=valpos3(*,1)
  valpos(*,2,2)=valpos3(*,2)

  valpos(*,0,3)=valpos4(*,0)
  valpos(*,1,3)=valpos4(*,1)
  valpos(*,2,3)=valpos4(*,2)      
 
  PRINT, 'Positions array:'
  
  help, valpos  
  
; releasing old and unnecessary arrays
 
  valpos1=0 & valpos2=0 &valpos3=0 & valpos4=0
 

; a single array for mag values (time,xyz,S/C)

  valmag=dblarr(np1,3,4)
  
  valmag(*,0,0)=valmag1(*,0)
  valmag(*,1,0)=valmag1(*,1)
  valmag(*,2,0)=valmag1(*,2)
  

  valmag(*,0,1)=valmag2(*,0)
  valmag(*,1,1)=valmag2(*,1)
  valmag(*,2,1)=valmag2(*,2)

  valmag(*,0,2)=valmag3(*,0)
  valmag(*,1,2)=valmag3(*,1)
  valmag(*,2,2)=valmag3(*,2)

  valmag(*,0,3)=valmag4(*,0)
  valmag(*,1,3)=valmag4(*,1)
  valmag(*,2,3)=valmag4(*,2)      

  PRINT, 'Mag array:'
    
  help, valmag   
  
; releasing old and unnecessary arrays
 
  valmag1=0 & valmag2=0 &valmag3=0 & valmag4=0
  
; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX  
  
