; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; IDL CRIB SHEET:
; crib_tplot_option_for_curlometer.pro : include IDL file
;         
; PURPOSE:
;        define option for tplot commande as 
;        tplot, ['all_bx','all_by','all_bz','all_b','Dij','J_cur','Div',$
;                'Div_Curl','JXB_Norm', 'JB_Angle']
;        used as include file by crib_MAIN_mms_curlometer_tplot.pro
;
; USAGE: @crib_tplot_option_for_curlometer.pro
;
;$CreatedBy: O. Le Contel & P. Robert $
;$LastChangedDate:  2015-11-24
; -----------------------------------------------------------------------

  PRINT, 'options for plots done in crib_MAIN_mms_curlometer_tplot.pro:' 
  PRINT
                                                   
  options,mms1_mag_name+'_bvec',colors=[0];black
  options,mms2_mag_name+'_bvec',colors=[6];red
  options,mms3_mag_name+'_bvec',colors=[4];green
  options,mms4_mag_name+'_bvec',colors=[2];blue

  split_vec,mms1_mag_name+'_bvec'
  split_vec,mms2_mag_name+'_bvec'
  split_vec,mms3_mag_name+'_bvec'
  split_vec,mms4_mag_name+'_bvec'

  options,mms1_mag_name+'_btot',colors=[0];black
  options,mms2_mag_name+'_btot',colors=[6];red
  options,mms3_mag_name+'_btot',colors=[4];green
  options,mms4_mag_name+'_btot',colors=[2];blue

  store_data,'all_bx',data=[mms1_mag_name+'_bvec_x',mms2_mag_name+'_bvec_x',mms3_mag_name+'_bvec_x',mms4_mag_name+'_bvec_x']
  store_data,'all_by',data=[mms1_mag_name+'_bvec_y',mms2_mag_name+'_bvec_y',mms3_mag_name+'_bvec_y',mms4_mag_name+'_bvec_y']
  store_data,'all_bz',data=[mms1_mag_name+'_bvec_z',mms2_mag_name+'_bvec_z',mms3_mag_name+'_bvec_z',mms4_mag_name+'_bvec_z']
  store_data,'all_b' ,data=[mms1_mag_name+'_btot'  ,mms2_mag_name+'_btot'  ,mms3_mag_name+'_btot'  ,mms4_mag_name+'_btot']

; options,mms1_pos_name+'_interp',colors=[0];black
; options,mms2_pos_name+'_interp',colors=[6];red
; options,mms3_pos_name+'_interp',colors=[4];green
; options,mms4_pos_name+'_interp',colors=[2];blue

; split_vec,mms1_pos_name+'_interp'
; split_vec,mms2_pos_name+'_interp'
; split_vec,mms3_pos_name+'_interp'
; split_vec,mms4_pos_name+'_interp'

; store_data,'all_posx',data=[mms1_pos_name+'_interp_0',mms2_pos_name+'_interp_0',mms3_pos_name+'_interp_0',mms4_pos_name+'_interp_0']
; store_data,'all_posy',data=[mms1_pos_name+'_interp_1',mms2_pos_name+'_interp_1',mms3_pos_name+'_interp_1',mms4_pos_name+'_interp_1']
; store_data,'all_posz',data=[mms1_pos_name+'_interp_2',mms2_pos_name+'_interp_2',mms3_pos_name+'_interp_2',mms4_pos_name+'_interp_2']
  
  PRINT
  PRINT, 'options all_bx etc. :'
  
  options,'all_bx','ytitle',' Bx ('+coord_mag+') !C!C'
  options,'all_by','ytitle',' By ('+coord_mag+') !C!C'
  options,'all_bz','ytitle',' Bz ('+coord_mag+') !C!C'
  options,'all_b' ,'ytitle',' B !C!C'

  options,'all_bx','labels', ['']
  options,'all_by','labels', ['']
  options,'all_bz','labels', ['']
  options,'all_b' ,'labels', ['']
  
; options,'all_bx',panel_size=1.5
; options,'all_by',panel_size=1.5
; options,'all_bz',panel_size=1.5
; options,'all_b' ,panel_size=1.5

; options,'all_posx','ytitle',' X ("+coord_mag_input+") !C!C'
; options,'all_posy','ytitle',' Y ("+coord_mag_input+") !C!C'
; options,'all_posz','ytitle',' Z ("+coord_mag_input+") !C!C'
  
  PRINT
  PRINT, 'options Curl, Div etc. :'
  
  options, 'Dij'     , ytitle='D!dij!N!C!C[km]'
  options, 'Dij'     , colors=[6,4,2,7,1,3]
  options, 'Dij'     , ynozero=1

  options, 'J_cd'    , panel_size=1.5
  options, 'J_cd'    , ytitle='J!C!C[nA/m2]'
  options, 'J_cd'    , colors=[6,4,2,0]
  options, 'J_cd'    , constant=0.
    
; options, 'Div'     , panel_size=1.5
  options, 'Div'     , ytitle='div(B)!C!C[nT/km]'
  options, 'Div'     , constant=0.
  
; options, 'Div_Curl', panel_size=1.5
  options, 'Div_Curl', ytitle='div(B)!C---!Ccurl(B)'
  options, 'Div_Curl', constant=0.
  
  options, 'JXB'     , panel_size=1.5
  options, 'JXB'     , ytitle='JxB N=10!A6!C!C[mV/m]'
  options, 'JXB'     , colors=[6,4,2,0]
  options, 'JXB'     , constant=0.
  
; options, 'JXB_Norm', panel_size=1.5
  options, 'JXB_Norm', ytitle='JxB!C!Cnormalized'
  options, 'JXB_Norm', colors=[6,4,2]
  
; options, 'JB_Angle', panel_size=1.5
  options, 'JB_Angle', ytitle='(J,B) angle!C!C[degree]'

  PRINT, '------------------------------------------------------------'
  PRINT, 'window size and tplot_option :'

  window, 0, ysize=1000,xsize=707 
  tplot_options, 'region',[0.07,0.07,.93,.93]
  tplot_options, 'charsize',1.1
  tplot_options, 'charthick',1.
  tplot_options, 'xmargin', [10, 0] ; left and right margin in cha. space
  tplot_options, 'ymargin', [1, 1]
  
  T1    = strmid(starting_time,0,2) + strmid(starting_time,3,2) + $
          strmid(starting_time,6,2)
  T2    = strmid(ending_time,0,2)   + strmid(ending_time,3,2)   + $
          strmid(ending_time,6,2)
  
  tplot_options,title= 'MMS 1,2,3&4 '+ mag_data_rate+' period, on '+ $
                strmid(date,0,10) +'  T: ' +T1 +' - ' +T2
  
; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
  
