; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; FUNCTION:
; datim_iso.pro : IDL function
;         
; PURPOSE:
;     return current date/time at ISO format as 2001-08-30T14:55:37.000Z 
 
; INPUT : none 
; USAGE : isodatim = datim_iso()
;
;$CreatedBy:P. Robert, LPP, September 2011 $
; 
; ----------------------------------------------------------------------

  FUNCTION datim_iso

  
  s24=systime()
  
  cmon= ['Jan','Feb','Mar','Apr','May','Jun', 'Jul', $
         'Aug','Sep','Oct','Nov','Dec']
  imon= ['01','02','03','04','05','06','07','08','09','10','11','12']     
     
  cmois=strmid(s24,4,3)     
  i=where(cmois EQ cmon)
  mois=imon(i)
  
  dat_time=strmid(s24,20,4) +'-' +mois +'-' +strmid(s24,8,2) +'T'  $
         +strmid(s24,11,8) +'.000Z'
     
  RETURN, dat_time
  END  
  
; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

