; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; FUNCTION:
; tu_julsec_to_isodate.pro : IDL function
;         
; PURPOSE:
;        Convert Julian second since 1970/01/01 in ISO date time
;
; INPUT : Jul_sec, Ndigit
; RETURN: isodatim
; USAGE : isodatim = tu_julsec_to_isodate(Jul_sec,8)
;
;$CreatedBy: P. Robert, CETP, December 2006 $
 
; ----------------------------------------------------------------------

  FUNCTION tu_julsec_to_isodate, Jul_sec, Ndigit

  str_date= tu_secdate(Jul_sec ,sec_day, FMT=0)
  str_time= tu_secday_to_strtime(sec_day,Ndigit)

  isodatim= STRTRIM(str_date,2) +'T' +STRTRIM(str_time,2) +'Z'

  RETURN, isodatim
  END

; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
