; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; FUNCTION:
; tu_julsec_to_isodatea.pro : IDL function
;         
; PURPOSE:
;        Convert Julian second since 1970/01/01 in ISO date time
;        Although tu_julsec_to_isodate  procedure can work with array,
;        the new  tu_julsec_to_isodatea procedure run more fastly with arrays.
;
; INPUT : Arrays Jul_sec, Ndigit
; RETURN: isodatim array
; USAGE : isodatim = tu_julsec_to_isodate(Jul_sec,8)
;
;$CreatedBy: P. Robert, CETP, March 2007 ; revised August 2011 $
 
; ----------------------------------------------------------------------

  FUNCTION tu_julsec_to_isodatea, Jul_sec, Ndigit

  ndim=N_ELEMENTS(Jul_sec)

  IF(ndim LE 1) THEN BEGIN
      PRINT, '*** tu_julsec_to_isodatea: first argument must be an array'
      PRINT, '    use tu_julsec_to_isodate for scalar argument'
      PRINT, '*** Nothing is done'
      PRINT, '*** an IDL EXIT is suggered'
      PRINTF,-2,'tu_julsec_to_isodatea : first argument must be an array   /***'
      EXIT
      ENDIF

  isodatim=STRARR(ndim)

; date for the 1st element:

  str_date1= tu_secdate(Jul_sec(0) ,sec_day, FMT=0.)
  julsec1  = Jul_sec(0) -sec_day

  str_time= tu_secday_to_strtime(sec_day,Ndigit)
  isodatim(0)= STRTRIM(str_date1,2) +'T' +STRTRIM(str_time,2) +'Z'

; loop on the rest of the array
; call to tu_secdate (heavy!) is done only when the day is changing

  FOR i=1L, ndim-1L DO BEGIN

  sec_day= Jul_sec(i) -julsec1

  IF (sec_day GT 86400.D0) THEN BEGIN
                           str_date1= tu_secdate(Jul_sec(i) ,sec_day, FMT=0)
                           julsec1  = Jul_sec(i) -sec_day
                           PRINT, '   i= ',i,  'isodatim(i)=',isodatim(i)
                           ENDIF

  str_time= tu_secday_to_strtime(sec_day,Ndigit)
  isodatim(i)= STRTRIM(str_date1,2) +'T' +STRTRIM(str_time,2) +'Z'
  ENDFOR

  RETURN, isodatim
  END

; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
