; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; FUNCTION:
; tu_julsec_to_isodate.pro : IDL function
;         
; PURPOSE:
;         convert second of the day to a string as HH:MM:SS.12345
;
; INPUT : 
;       secday: second of the day (double floating point type)
;       nbdec is the number of digits after decimal point of second.
;
;       If the input is greater than 86400. (24 hours), time will be
;       subtracted in 24 hour chunks, until the time is less than 24 hours.
;
;       If seconds is given negative, an error is displayed.
;
; USAGE : string_hour = tu_secday_to_strtime(secday, nbdec)
;
;$CreatedBy: P. Robert, CETP, November 2006 $
 
; ----------------------------------------------------------------------

  FUNCTION  tu_secday_to_strtime, secday, nbdec


; check for validity of input (all input values GE 0.)

  IF(WHERE(secday LT 0.))(0) NE -1 THEN   RETURN, 'ERROR sec <0.' 
  IF(nbdec LT  0) THEN RETURN, 'ERROR nbdec < 0'
  IF(nbdec GT 20) THEN RETURN, 'ERROR nbdec >20'

; compute integer hrs, min, sec

  seconds = LONG(secday)

  hrs = seconds/3600
  min =(seconds - hrs*3600)/60
  sec = seconds - hrs*3600 - min*60

; get hours are within 24 hours

  hrs = hrs mod 24

; get decimal part of the seconds

  decsec= secday -DOUBLE(seconds)

; build final time string as HH:MM:SS.123456 ...

  fmt= STRING('(f',nbdec+2,'.',nbdec,')', FORMAT="(a2,i2.2,a1,i2.2,a1)")
  str_decsec= STRING(decsec, FORMAT=fmt)

  strtime= STRING(hrs,FORMAT="(i2.2,':')") + $
           STRING(min,FORMAT="(i2.2,':')") + $
           STRING(sec,FORMAT="(i2.2)")     + $
           STRMID(str_decsec,1,nbdec+1)

  RETURN, strtime

  END

; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
